<?php
require APPPATH . '/libraries/REST_Controller.php';
require_once('vendor/autoload.php');
class Dashboard extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('username') == NULL && $this->session->userdata('password') == NULL) {
            redirect(base_url() . "login");
        }
        $this->load->model('Home_model', 'home');
        $this->load->library('form_validation');
    }
    function index()
	{
        $uid = $this->session->userdata('uid');
        $data['page'] = $this->home->landingpage();
        $data['akun'] = $this->home->get_akunbyid($uid);
        $data['customer'] = $this->home->getallAkunCustomer();
        $data['driver'] = $this->home->getallAkunDriver();
        $this->load->view('includes/header_admin',$data);
        $this->load->view('panel/index', $data);
        $this->load->view('includes/footer_admin',$data);
	}
    function akuncs()
	{
        $uid = $this->session->userdata('uid');
        $data['page'] = $this->home->landingpage();
        $data['akun'] = $this->home->get_akunbyid($uid);
        $data['allakun'] = $this->home->getallAkunCustomer();
        $this->load->view('includes/header_admin',$data);
        $this->load->view('panel/customer', $data);
        $this->load->view('includes/footer_admin',$data);
	}
    function akundv()
	{
        $uid = $this->session->userdata('uid');
        $data['page'] = $this->home->landingpage();
        $data['akun'] = $this->home->get_akunbyid($uid);
        $data['allakun'] = $this->home->getallAkunDriver();
        $this->load->view('includes/header_admin',$data);
        $this->load->view('panel/customer', $data);
        $this->load->view('includes/footer_admin',$data);
	}
    function transasction()
	{
        $uid = $this->session->userdata('uid');
        $data['page'] = $this->home->landingpage();
        $data['akun'] = $this->home->get_akunbyid($uid);
        $data['transaksi'] = $this->home->getalltransaksidashboard();
        $this->load->view('includes/header_admin',$data);
        $this->load->view('panel/transaksi', $data);
        $this->load->view('includes/footer_admin',$data);
	}
    function fitur()
	{
        $uid = $this->session->userdata('uid');
        $data['page'] = $this->home->landingpage();
        $data['akun'] = $this->home->get_akunbyid($uid);
        $data['fitur'] = $this->home->get_fitur();
        $this->load->view('includes/header_admin',$data);
        $this->load->view('panel/fitur', $data);
        $this->load->view('includes/footer_admin',$data);
	}
    public function tambahfitur()
    {
        $this->form_validation->set_rules('fitur', 'fitur', 'trim|prep_for_form');
        $this->form_validation->set_rules('minharga', 'minharga', 'trim|prep_for_form');
        $this->form_validation->set_rules('minjarak', 'minjarak', 'trim|prep_for_form');
        $this->form_validation->set_rules('harga', 'harga', 'trim|prep_for_form');
        $this->form_validation->set_rules('parkir', 'parkir', 'trim|prep_for_form');
        $this->form_validation->set_rules('diskon', 'diskon', 'trim|prep_for_form');
        $this->form_validation->set_rules('modul', 'modul', 'trim|prep_for_form');
        $this->form_validation->set_rules('status', 'status', 'trim|prep_for_form');
        
        if ($this->form_validation->run() == TRUE) {  
            $config['upload_path']     = './images/fitur/';
            $config['allowed_types'] = 'gif|jpg|png|jpeg';
            $config['max_size']         = '10000';
            $config['file_name']     = 'name';
            $config['encrypt_name']     = true;
            $this->load->library('upload', $config);
            $data = $this->home->get_fiturbyid($id);
            if ($this->upload->do_upload('icon')) {
                $app_logo = html_escape($this->upload->data('file_name'));
            }else{
                $app_logo = 'noimage.jpg';
            }
            $data                   = [
                'id'                            => html_escape($this->input->post('id', TRUE)),
                'fitur'                          => html_escape($this->input->post('fitur', TRUE)),
                'harga'                         => html_escape($this->input->post('harga', TRUE)),
                'parkir'                    => html_escape($this->input->post('parkir', TRUE)),
                'diskon'                    => html_escape($this->input->post('diskon', TRUE)),
                'layanan'                    => html_escape($this->input->post('modul', TRUE)),
                'page'                    => html_escape($this->input->post('modul', TRUE)),
                'minharga'                         => html_escape($this->input->post('minharga', TRUE)),
                'minjarak'                    => html_escape($this->input->post('minjarak', TRUE)),
                'icon'                          => $app_logo,
                'status_fitur'                        => html_escape($this->input->post('status_fitur', TRUE))
            ];
            $this->home->addfitur($data);
            $this->session->set_flashdata('edit', 'Fitur berhasil Ditambahkan');
            redirect('home');
        } else {
            $uid = $this->session->userdata('uid');
            $data['page'] = $this->home->landingpage();
            $data['akun'] = $this->home->get_akunbyid($uid);
            $this->load->view('includes/header_admin',$data);
            $this->load->view('panel/addfitur', $data);
            $this->load->view('includes/footer_admin',$data);
        }
    }
    public function editfitur($id)
    {
        $this->form_validation->set_rules('fitur', 'fitur', 'trim|prep_for_form');
        $this->form_validation->set_rules('minharga', 'minharga', 'trim|prep_for_form');
        $this->form_validation->set_rules('minjarak', 'minjarak', 'trim|prep_for_form');
        $this->form_validation->set_rules('harga', 'harga', 'trim|prep_for_form');
        $this->form_validation->set_rules('parkir', 'parkir', 'trim|prep_for_form');
        $this->form_validation->set_rules('diskon', 'diskon', 'trim|prep_for_form');
        $this->form_validation->set_rules('modul', 'modul', 'trim|prep_for_form');
        $this->form_validation->set_rules('status', 'status', 'trim|prep_for_form');
        
        if ($this->form_validation->run() == TRUE) {  
            $config['upload_path']     = './images/fitur/';
            $config['allowed_types'] = 'gif|jpg|png|jpeg';
            $config['max_size']         = '10000';
            $config['file_name']     = 'name';
            $config['encrypt_name']     = true;
            $this->load->library('upload', $config);
            $data = $this->home->get_fiturbyid($id);
            if ($this->upload->do_upload('icon')) {
                if ($data['icon'] != 'noimage.jpg') {
                    $gambar = $data['icon'];
                    unlink('./images/fitur/' . $gambar);
                }
                $app_logo = html_escape($this->upload->data('file_name'));
            } else {
                $app_logo = $data['icon'];
            }
            $data                   = [
                'id'                            => html_escape($this->input->post('id', TRUE)),
                'fitur'                          => html_escape($this->input->post('fitur', TRUE)),
                'harga'                         => html_escape($this->input->post('harga', TRUE)),
                'parkir'                    => html_escape($this->input->post('parkir', TRUE)),
                'diskon'                    => html_escape($this->input->post('diskon', TRUE)),
                'layanan'                    => html_escape($this->input->post('modul', TRUE)),
                'page'                    => html_escape($this->input->post('modul', TRUE)),
                'minharga'                         => html_escape($this->input->post('minharga', TRUE)),
                'minjarak'                    => html_escape($this->input->post('minjarak', TRUE)),
                'icon'                          => $app_logo,
                'status'                        => html_escape($this->input->post('status', TRUE))
            ];
            $this->home->editfitur($data);
            $this->session->set_flashdata('edit', 'Fitur berhasil Diubah');
            redirect('dashboard');
        } else {
            $uid = $this->session->userdata('uid');
            $data['page'] = $this->home->landingpage();
            $data['akun'] = $this->home->get_akunbyid($uid);
            $data['fitur'] = $this->home->get_fiturbyid($id);
            $this->load->view('includes/header_admin',$data);
            $this->load->view('panel/editfitur', $data);
            $this->load->view('includes/footer_admin',$data);
        }
    }
    public function hapusfitur($id)
    {
        $data = $this->home->get_fiturbyid($id);
        $gambar = $data['icon'];
        unlink('./images/fitur/' . $gambar);
        $this->home->hapusfitur($id);
        $this->session->set_flashdata('hapus', 'Paket Berhasil Dihapus');
        redirect('home');
    }
    public function hapusakun($id)
    {
        $data = $this->home->get_akunbyid($id);
        $gambar = $data['foto'];
        unlink('./images/pelanggan/' . $gambar);
        $this->home->hapusakun($id);
        $this->session->set_flashdata('hapus', 'Akun Berhasil Dihapus');
        redirect('home');
    }
    public function editakun($id)
    {
        $this->form_validation->set_rules('nama', 'nama', 'trim|prep_for_form');
        $this->form_validation->set_rules('username', 'username', 'trim|prep_for_form');
        $this->form_validation->set_rules('password', 'password', 'trim|prep_for_form');
        $this->form_validation->set_rules('email', 'email', 'trim|prep_for_form');
        
        if ($this->form_validation->run() == TRUE) {  
            $config['upload_path']     = './images/pelanggan/';
            $config['allowed_types'] = 'gif|jpg|png|jpeg';
            $config['max_size']         = '10000';
            $config['file_name']     = 'name';
            $config['encrypt_name']     = true;
            $this->load->library('upload', $config);
            $data = $this->home->get_akunbyid($id);
            if ($this->upload->do_upload('foto')) {
                if ($data['foto'] != 'noimage.jpg') {
                    $gambar = $data['foto'];
                    unlink('./images/pelanggan/' . $gambar);
                }
                $app_logo = html_escape($this->upload->data('file_name'));
            } else {
                $app_logo = $data['icon'];
            }
            $data                   = [
                'uid'                            => html_escape($this->input->post('id', TRUE)),
                'fullnama'                          => html_escape($this->input->post('nama', TRUE)),
                'username'                         => html_escape($this->input->post('username', TRUE)),
                'password'                    => html_escape($this->input->post('password', TRUE)),
                'email'                    => html_escape($this->input->post('email', TRUE)),
                'foto'                          => $app_logo
            ];
            $this->home->editakun($data);
            $this->session->set_flashdata('edit', 'Akun berhasil Diubah');
            redirect('home');
        } else {
            $uid = $this->session->userdata('uid');
            $data['akun'] = $this->home->get_akunbyid($uid);
            $data['page'] = $this->home->landingpage();
            $data['dataakun'] = $this->home->get_akunbyid($id);
            $this->load->view('includes/header_admin',$data);
            $this->load->view('panel/editakun', $data);
            $this->load->view('includes/footer_admin',$data);
        }
    }
    public function pengaturan($id)
    {
        $this->form_validation->set_rules('appname', 'appname', 'trim|prep_for_form');
        $this->form_validation->set_rules('alamat', 'alamat', 'trim|prep_for_form');
        $this->form_validation->set_rules('kontak', 'kontak', 'trim|prep_for_form');
        $this->form_validation->set_rules('email', 'email', 'trim|prep_for_form');
        $this->form_validation->set_rules('wagateway', 'wagateway', 'trim|prep_for_form');
        $this->form_validation->set_rules('maintenance', 'maintenance', 'trim|prep_for_form');
        
        if ($this->form_validation->run() == TRUE) {  
            $config['upload_path']     = './images/';
            $config['allowed_types'] = 'gif|jpg|png|jpeg';
            $config['max_size']         = '10000';
            $config['file_name']     = 'name';
            $config['encrypt_name']     = true;
            $this->load->library('upload', $config);
            $data = $this->home->get_akunbyid($id);
            if ($this->upload->do_upload('logo_white')) {
                if ($data['logo_white'] != 'logo_white.png') {
                    $gambar = $data['logo_white'];
                    unlink('./images/' . $gambar);
                }
                $logowhite = html_escape($this->upload->data('file_name'));
            } else {
                $logowhite = $data['logo_white'];
            }
            if ($this->upload->do_upload('logo_dark')) {
                if ($data['logo_dark'] != 'logo_dark.png') {
                    $gambar = $data['logo_dark'];
                    unlink('./images/' . $gambar);
                }
                $logodark = html_escape($this->upload->data('file_name'));
            } else {
                $logodark = $data['logo_dark'];
            }
            $data                   = [
                'id'                            => html_escape($this->input->post('id', TRUE)),
                'appname'                          => html_escape($this->input->post('appname', TRUE)),
                'alamat'                         => html_escape($this->input->post('alamat', TRUE)),
                'kontak'                    => html_escape($this->input->post('kontak', TRUE)),
                'email'                    => html_escape($this->input->post('email', TRUE)),
                'wagateway'                    => html_escape($this->input->post('wagateway', TRUE)),
                'logo_white'                          => $logowhite,
                'logo_dark'                          => $logodark,
                'maintenance'                    => html_escape($this->input->post('maintenance', TRUE)),
            ];
            $this->home->editsetting($data);
            $this->session->set_flashdata('edit', 'Akun berhasil Diubah');
            redirect('home');
        } else {
            $uid = $this->session->userdata('uid');
            $data['akun'] = $this->home->get_akunbyid($uid);
            $data['page'] = $this->home->landingpage();
            $this->load->view('includes/header_admin',$data);
            $this->load->view('panel/settings', $data);
            $this->load->view('includes/footer_admin',$data);
        }
    }
}