<?php
require APPPATH . '/libraries/REST_Controller.php';
require_once('vendor/autoload.php');
class Home extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('username') == NULL && $this->session->userdata('password') == NULL) {
            redirect(base_url() . "login");
        }
        $this->load->model('Home_model', 'home');
        $this->load->library('form_validation');
    }
	function index()
	{
        $uid = $this->session->userdata('uid');
        if($this->session->userdata('level') == 'admin'){
            $data['page'] = $this->home->landingpage();
            $data['akun'] = $this->home->get_akunbyid($uid);
            $data['customer'] = $this->home->getallAkunCustomer();
            $data['driver'] = $this->home->getallAkunDriver();
            $data['transaksi'] = $this->home->getalltransaksi();
            $data['ontransaksi'] = $this->home->getalltransaksiproses();
            $data['trx_all']   = $this->home->transaksi_all();
            $this->load->view('includes/header_admin',$data);
            $this->load->view('panel/index', $data);
            $this->load->view('includes/footer_admin',$data);
        }else{
            $data = $this->home->get_akunbyid($uid);
            if($data['alamat'] == null){
                $this->session->set_flashdata('error', 'Tentukan Alamat Kamu Dulu Yuk !!!');
                redirect('home/pickalamat');
            }else{
                $data['akun'] = $this->home->get_akunbyid($uid);
                $data['page'] = $this->home->landingpage();
                $data['fitur'] = $this->home->get_fitur();
                $data['banner'] = $this->home->get_banner();
                $data['alltransaksi'] = $this->home->get_alltransaksi();
                $data['progress'] = $this->home->get_transaksiprogesss($uid);
                
                //end notif
                $this->load->view('includes/header',$data);
                $this->load->view('pelanggan/index', $data);
                $this->load->view('includes/footer',$data);
            }
        }
	}

    function progressorder($id)
	{
        if($this->session->userdata('type') == '0'){
            $uid = $this->session->userdata('uid');
            $data['akun'] = $this->home->get_akunbyid($uid);
            $data['page'] = $this->home->landingpage();
            $data['fitur'] = $this->home->get_fitur();
            $data['banner'] = $this->home->get_banner();
            $data['transaksi'] = $this->home->get_transaksibyid($id);
            $this->load->view('includes/header',$data);
            $this->load->view('pelanggan/prosesorder', $data);
            $this->load->view('includes/footer',$data);
        }else{
            redirect('home');
        }
        
	}
    function akun()
	{
        $uid = $this->session->userdata('uid');
        $data['page'] = $this->home->landingpage();
        $data['akun'] = $this->home->get_akunbyid($uid);
        $this->load->view('includes/header',$data);
		$this->load->view('pelanggan/profile', $data);
        $this->load->view('includes/footer',$data);
	}
    function listchatdriver()
	{
        $uid = $this->session->userdata('uid');
        $data['page'] = $this->home->landingpage();
        $data['akun'] = $this->home->get_akunbyid($uid);
        $data['chat'] = $this->home->dataallchat_driver($uid);
        $this->load->view('includes/header',$data);
		$this->load->view('pelanggan/chataktif', $data);
        $this->load->view('includes/footer',$data);
	}
    function listchatcustomer()
	{
        $uid = $this->session->userdata('uid');
        $data['page'] = $this->home->landingpage();
        $data['akun'] = $this->home->get_akunbyid($uid);
        $data['chat'] = $this->home->dataallchat_customer($uid);
        $this->load->view('includes/header',$data);
		$this->load->view('pelanggan/chataktif', $data);
        $this->load->view('includes/footer',$data);
	}
    function chat($id)
	{
        $uid = $this->session->userdata('uid');
        $data['page'] = $this->home->landingpage();
        $data['akun'] = $this->home->get_akunbyid($uid);
        $data['chat'] = $this->home->datachat($id);
        $data['idtrans'] = $id;
        $this->load->view('includes/header',$data);
		$this->load->view('pelanggan/chat', $data);
        $this->load->view('includes/footer',$data);
	}
    function pengaturan()
	{
        $uid = $this->session->userdata('uid');
        $data['page'] = $this->home->landingpage();
        $data['akun'] = $this->home->get_akunbyid($uid);
        $this->load->view('includes/header',$data);
		$this->load->view('pelanggan/settings', $data);
        $this->load->view('includes/footer',$data);
	}
    function orderan()
	{
        $uid = $this->session->userdata('uid');
        $check_exist = $this->home->check_exist_transaksibyakun($uid);
 
        if($check_exist){
            $data['page'] = $this->home->landingpage();
            $data['akun'] = $this->home->get_akunbyid($uid);
            $data['transaksi'] = $this->home->get_alltransaksibyakun($uid);
            $this->load->view('includes/header',$data);
            $this->load->view('pelanggan/listorder', $data);
            $this->load->view('includes/footer',$data);
        }else{
            $data['page'] = $this->home->landingpage();
            $data['akun'] = $this->home->get_akunbyid($uid);
            $data['transaksi'] = $this->home->get_transaksibyakun($uid);
            $this->load->view('includes/header',$data);
            $this->load->view('pelanggan/listorder', $data);
            $this->load->view('includes/footer',$data);
        }
        
	}
    function riwayat()
	{
        $uid = $this->session->userdata('uid');
        if($this->session->userdata('type') == '1'){
            $data['page'] = $this->home->landingpage();
            $data['akun'] = $this->home->get_akunbyid($uid);
            $data['trx_all']         = $this->home->pendapatandriver($uid);
            $data['counttrx']          = $this->home->countransaksidriver($uid);
            $data['transaksi'] = $this->home->get_transaksibyakundriver($uid);
            $this->load->view('includes/header',$data);
            $this->load->view('pelanggan/riwayat', $data);
            $this->load->view('includes/footer',$data);
        }else{
            redirect('home');
        }
	}
    function editakun($uid)
	{
        $this->form_validation->set_rules('username', 'username', 'trim|prep_for_form');
        $this->form_validation->set_rules('fullnama', 'fullnama', 'trim|prep_for_form');
        $this->form_validation->set_rules('kontak', 'kontak', 'trim|prep_for_form');
        $this->form_validation->set_rules('email', 'email', 'trim|prep_for_form');
        
        if ($this->form_validation->run() == TRUE) {  
            $config['upload_path']     = './images/pelanggan/';
            $config['allowed_types'] = 'gif|jpg|png|jpeg';
            $config['max_size']         = '10000';
            $config['file_name']     = 'name';
            $config['encrypt_name']     = true;
            $this->load->library('upload', $config);
            $data = $this->home->get_akunbyid($uid);
            if ($this->upload->do_upload('foto')) {
                if ($data['foto'] != 'noimage.jpg') {
                    $gambar = $data['foto'];
                    unlink('./images/pelanggan/' . $gambar);
                }
                $profile= html_escape($this->upload->data('file_name'));
            } else {
                $profile = $data['foto'];
            }
            $data                   = [
                'uid'                            => $uid,
                'username'                          => html_escape($this->input->post('username', TRUE)),
                'fullnama'                         => html_escape($this->input->post('fullnama', TRUE)),
                'email'                    => html_escape($this->input->post('email', TRUE)),
                'kontak'                    => html_escape($this->input->post('kontak', TRUE)),
                'isgps'                    => html_escape($this->input->post('gps', TRUE)),
                'foto'                          => $profile
            ];
            $this->home->editprofile($data);
            $this->session->set_flashdata('ubah', 'Akun berhasil Diubah');
            redirect('home/akun');
        } else {
            
            $data['page'] = $this->home->landingpage();
            $uid = $this->session->userdata('uid');
            $data['akun'] = $this->home->get_akunbyid($uid);
            $this->load->view('includes/header',$data);
            $this->load->view('pelanggan/editprofile', $data);
            $this->load->view('includes/footer',$data);
        }

	}
    function pickalamat()
	{
        $uid = $this->session->userdata('uid');
        $data['akun'] = $this->home->get_akunbyid($uid);
        $data['page'] = $this->home->landingpage();
        $this->load->view('includes/header',$data);
		$this->load->view('pelanggan/ubahalamat', $data);
        $this->load->view('includes/footer',$data);
	}
    public function editalamat($id)
    {
        $this->form_validation->set_rules('alamat', 'alamat', 'trim|prep_for_form');
        $this->form_validation->set_rules('latitude', 'latitude', 'trim|prep_for_form');
        $this->form_validation->set_rules('longitude', 'longitude', 'trim|prep_for_form');
        if ($this->form_validation->run() == TRUE) {  
            $data                   = [
                'uid'                            => $id,
                'alamat'                          => html_escape($this->input->post('alamat', TRUE)),
                'latitude'                         => html_escape($this->input->post('latitude', TRUE)),
                'longitude'                        => html_escape($this->input->post('longitude', TRUE))
            ];
            $this->home->editalamat($data);
            $this->session->set_flashdata('ubah', 'Alamat berhasil Diubah');
            redirect('home/akun');
        } else {
            $uid = $this->session->userdata('uid');
            $data['akun'] = $this->home->get_akunbyid($uid);
            $data['page'] = $this->home->landingpage();
            $this->load->view('includes/header',$data);
            $this->load->view('pelanggan/ubahalamat', $data);
            $this->load->view('includes/footer',$data);
        }
    }
    function ride($id)
	{
        if($this->session->userdata('type') == '0'){
            $uid = $this->session->userdata('uid');
            $data['akun'] = $this->home->get_akunbyid($uid);
            $data['page'] = $this->home->landingpage();
            $data['fitur'] = $this->home->get_fiturbyid($id);
            $data['banner'] = $this->home->get_bannerride('ride');
            $this->load->view('includes/header',$data);
            $this->load->view('pelanggan/ride', $data);
            $this->load->view('includes/footer',$data);
        }else{
            redirect('home');
        }
        
	}
    function belanja($id)
	{
        if($this->session->userdata('type') == '0'){
            $uid = $this->session->userdata('uid');
            $data['akun'] = $this->home->get_akunbyid($uid);
            $data['page'] = $this->home->landingpage();
            $data['fitur'] = $this->home->get_fiturbyid($id);
            $data['banner'] = $this->home->get_bannerride('merchant');
            $this->load->view('includes/header',$data);
            $this->load->view('pelanggan/belanja', $data);
            $this->load->view('includes/footer',$data);
        }else{
            redirect('home');
        }
        
	}
    
    function sukses_order()
	{
        $uid = $this->session->userdata('uid');
        $data['akun'] = $this->home->get_akunbyid($uid);
        $data['page'] = $this->home->landingpage();
		$this->load->view('pelanggan/suksesorder', $data);
	}
    function datadriver($idtrans,$lat,$lng)
	{
        if($this->session->userdata('type') == '0'){
            $check_exist = $this->home->check_exist_driver();
            $datatrans = $this->home->datatransbyid($idtrans);
            if($check_exist){
                $checkorderaktif = $this->home->cekorderanaktif($idtrans);
                if($checkorderaktif){
                    $uid = $this->session->userdata('uid');
                    $cekpengajuan = $this->home->cekpengajuan($idtrans);
                    if($cekpengajuan){
                        $data['status_pengajuan'] = 'ada';
                        $datapengajuan = $this->home->get_pengajuanbyid($idtrans);
                        foreach ($datapengajuan as $pengajuan) {
                            $datapengajuandriver = $this->home->get_pengajuanbydriver($pengajuan['idtrans'],$pengajuan['iddriver']);
                            foreach ($datapengajuandriver as $pengajuandriver) {
                                $data['datapengajuan'] = $pengajuandriver['pengajuan'];    
                            }
                            
                        }
                    }else{
                        $data['status_pengajuan'] = 'tidak';
                    }
                    
                    $data['akun'] = $this->home->get_akunbyid($uid);
                    $data['page'] = $this->home->landingpage();
                    $data['driver'] = $this->home->get_data_driver($lat,$lng);
                    $data['idtrans'] = $idtrans;
                    $data['transaksi'] = $this->home->get_transaksibyid($idtrans);
                    
                    $this->load->view('includes/header',$data);
                    $this->load->view('pelanggan/listdriver', $data);
                    $this->load->view('includes/footer',$data);
                }else{
                    $this->session->set_flashdata('orderan', 'Pesanan Sudah Tidak Tersedia');
                    redirect('home/index');
                }
            }else{
                $this->session->set_flashdata('orderan', 'Tidak Ada Driver Disekitar');
                redirect('home/index');
            }
        }else{
            redirect('home');
        }
	}
   
    function konfirmasi($id,$iddriver)
	{
        $check_exist = $this->home->check_exist_transaksi($id);
        if($check_exist){
            $uid = $this->session->userdata('uid');
            $data['akun'] = $this->home->get_akunbyid($uid);
            $data['page'] = $this->home->landingpage();
            $data['fitur'] = $this->home->get_fiturbyid($id);
            $data['transaksi'] = $this->home->get_transaksibyid($id);
            //--------------- send notif -----------------------------
            $datapengguna = $this->home->alldatacustomerbytrx($id);
            $registrationIDs = [
                '1234'
            ];
            foreach ($datapengguna as $customer) {
                $registrationIDs = [
                    $customer['token']
                ];
            }
    
            $datanotif = [
                'title' => 'OrderIn',
                'body' => 'Pesanan Kamu Telah Dikonfirmasi!!',
                'type' => '3',
                'link' => base_url().'/home/progressorder/'.$id,
                'idtrans' => $id
              ];
              $this->home->kirimnotif($registrationIDs,$datanotif);
            //--------------------------------------------------------
            $this->load->view('includes/header',$data);
            $this->load->view('pelanggan/konfirm', $data);
            $this->load->view('includes/footer',$data);
        }else{
            redirect('home/index');
        }
        
	}
    function konfirmasidriver($idtrans)
	{
        $uid = $this->session->userdata('uid');
        $check_exist = $this->home->check_exist_transaksi($idtrans);
        if($check_exist){
            $dataakun = $this->home->get_akunbyid($uid);
            $data                   = [
                'idtrans'          => $idtrans,
                'iddriver'          => $uid,
                'token_driver'          => $dataakun['token']
            ];
            //--------------- send notif -----------------------------
            $datatrans = $this->home->datatransbyid($idtrans);
            $tokendevice = $datatrans->row('token_cs');
            $registrationIDs = [
                $tokendevice
            ];
            $datanotif = [
                'title' => 'OrderIn',
                'body' => 'Pesanan Kamu Telah Di Konfirmasi!!',
                'type' => '2',
                'link' => base_url().'/home/progressorder/'.$idtrans,
                'idtrans' => $idtrans
            ];
            $this->home->kirimnotif($registrationIDs,$datanotif);
            //--------------------------------------------------------
            $this->home->acceptorder($data);
            $this->session->set_flashdata('orderan', 'Orderan Berhasil Di Ambil');
           
            redirect('home/index');
        }else{
            $this->session->set_flashdata('orderan', 'Pesanan Tidak Tersedia');
            redirect('home/index');
        }
        
	}
    function terimapesanan($idtrans,$iddriver)
	{
        $check_exist = $this->home->check_exist_transaksi($idtrans);
            if($check_exist){
                $data                   = [
                    'idtrans'          => $idtrans,
                    'iddriver'          => $iddriver
                ];
                
                $this->home->acceptorder($data);
                $this->session->set_flashdata('orderan', 'Orderan Berhasil Di Ambil');
                //------------------- send notif ---------------------------------------------
                $kontak = "628991585001";
                $txt1 = "-------------------- Notifikasi Orderan -------------------"."\n";
                $txt2 = "Orderan Berhasil Di Ambil"."\n";
                $txt3 = "Buka Web Gojasa Cek Pesanan Kamu"."\n";
                $txt4 = base_url()."\n";
                $txt5 = "------------------------------------------------"."\n";
                $pesanwa = utf8_encode($txt1.$txt2.$txt3.$txt4.$txt5);
                $curl = curl_init();
                curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://apiwa.mwdigi.com/send-message',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => array('message' => $pesanwa,'number' => $kontak),
                ));
                $response = curl_exec($curl);
                curl_close($curl);
            //------------------------------------------------------------------------------
                redirect('home/index');
            }else{
                $this->session->set_flashdata('orderan', 'Pesanan Tidak Tersedia');
                redirect('home/index');
        }
	}
    function cancelorder($id,$iddriver)
	{
        $data                   = [
            'id'          => $id,
            'iddriver'          => $iddriver
        ];
        //--------------- send notif -----------------------------
        $datatrans = $this->home->datatransbyid($id);
        $tokendevice = $datatrans->row('token_driver');
        $registrationIDs = [
            $tokendevice
        ];
        $datanotif = [
            'title' => 'OrderIn',
            'body' => 'Pesanan Kamu Telah Di Batalkan!!',
            'type' => '0',
            'link' => base_url(),
            'idtrans' => $id
          ];
          $this->home->kirimnotif($registrationIDs,$datanotif);
        //--------------------------------------------------------
        $this->home->cancelorder($data);
        redirect('home/index');
	}
    function cancelorderindriver($id,$iddriver)
	{
        $data                   = [
            'id'          => $id,
            'iddriver'          => $iddriver
        ];
        //--------------- send notif -----------------------------
        $datatrans = $this->home->datatransbyid($id);
        $tokendevice = $datatrans->row('token_cs');
        $registrationIDs = [
            $tokendevice
        ];
        $datanotif = [
            'title' => 'OrderIn',
            'body' => 'Pesanan Kamu Telah Di Batalkan!!',
            'type' => '0',
            'link' => base_url(),
            'idtrans' => $id
          ];
          $this->home->kirimnotif($registrationIDs,$datanotif);
        //--------------------------------------------------------
        $this->home->cancelorder($data);
        redirect('home/index');
	}
    function request_driver($idtrans,$iddriver){
        $check_exist = $this->home->check_exist_transaksi($idtrans);
            if($check_exist){
                $cekpengajuan = $this->home->cekpengajuan($idtrans);
                if($cekpengajuan){
                    $data['status_pengajuan'] = 'ada';
                    $datapengajuan = $this->home->get_pengajuanbyid($idtrans);
                  
                    foreach ($datapengajuan as $pengajuan) {
                        $akundriver = $this->home->cekakundriver($pengajuan['iddriver']);
                        $datapengajuandriver = $this->home->get_pengajuanbydriver($pengajuan['idtrans'],$pengajuan['iddriver']);
                        foreach ($datapengajuandriver as $pengajuandriver) {
                            $data                   = [
                                'idtrans'          => $idtrans,
                                'iddriver'          => $iddriver,
                                'token_driver'          => $akundriver->row('token'),
                                'totalharga'          => $pengajuandriver['pengajuan'],
                            ];
                            $this->home->acceptorderbypengajuan($data);   
                        }
                    }
                }else{
                    $data                   = [
                        'idtrans'          => $idtrans,
                        'iddriver'          => $iddriver,
                    ];
                    $this->home->acceptorder($data);
                }
                //--------------- send notif -----------------------------
                $datapengguna = $this->home->get_akunbyids($iddriver);
                $registrationIDs = [
                    '1234'
                ];
                foreach ($datapengguna as $driver) {
                    $registrationIDs = [
                        $driver['token']
                    ];
                }

                $datanotif = [
                    'title' => 'OrderIn',
                    'body' => 'Customers Menerima Pengajuan Pesanan!!\nSegera Cek Aplikasi.',
                    'type' => '2',
                    'link' => base_url().'/home/detailorder/'.$idtrans,
                    'idtrans' => $idtrans
                  ];
                  $this->home->kirimnotif($registrationIDs,$datanotif);
                //--------------------------------------------------------
                redirect('home/progressorder/'.$idtrans);
            }else{
                $this->session->set_flashdata('orderan', 'Pesanan Tidak Tersedia');
                redirect('home/index');
        }
    }
    function accept_orderan($id,$iddriver){

        $datatrans = $this->home->datatransbyid($id);
        $datapelanggan = $this->home->datapelangganbyid($datatrans->row('idpelanggan'));
        
        $datafitur = $this->home->datafiturbyid($datatrans->row('fitur'));
        $alamattujuan = $datatrans->row('alamat_tujuan');
        $totalharga = html_escape($this->input->post('total_harga', TRUE));
        $txt1 = "-------------------- Orderan -------------------"."\n";
        $txt2 = "Order ID : ".$id."\n";
        $txt3 = "Pemesan : ".$datapelanggan->row('fullnama')."\n";
        $txt4 = "Fitur : ".$datafitur->row('fitur')."\n";
        $txt4 = "Biaya : ".rupiah($datatrans->row('totalharga'))."\n";
        $txt5 = "Buka Link Untuk Konfirmasi Pesanan"."\n";
        $txt6 = base_url()."home/terimapesanan/".$id."/".$iddriver."\n";
        $txt7 = "------------------------------------------------";
        $pesanwa = utf8_encode($txt1.$txt2.$txt3.$txt4.$txt5.$txt6.$txt7);
        $curl = curl_init();
        curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://apiwa.mwdigi.com/send-message',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => array('message' => $pesanwa,'number' => '08991585001'),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        redirect('home/progressorder/'.$id);
    }
     //-------------------------- Orderan Ojek -----------------------------
     function request_orderan(){
        $this->form_validation->set_rules('alamat_asal', 'alamat_asal', 'trim|prep_for_form');
        $this->form_validation->set_rules('alamat_tujuan', 'alamat_tujuan', 'trim|prep_for_form');
        $this->form_validation->set_rules('latitude_tujuan', 'latitude_tujuan', 'trim|prep_for_form');
        $this->form_validation->set_rules('longitude_tujuan', 'longitude_tujuan', 'trim|prep_for_form');

        $this->form_validation->set_rules('fitur', 'fitur', 'trim|prep_for_form');
        $this->form_validation->set_rules('ongkir', 'ongkir', 'trim|prep_for_form');
        $this->form_validation->set_rules('jarak', 'jarak', 'trim|prep_for_form');
        $this->form_validation->set_rules('diskon', 'diskon', 'trim|prep_for_form');
        $this->form_validation->set_rules('totalharga', 'totalharga', 'trim|prep_for_form');
        $idtrans = random_int(10000, 99999);
        $uid = $this->session->userdata('uid');
        $idfitur = html_escape($this->input->post('fitur', TRUE));
        $datapelanggan = $this->home->datapelangganbyid($uid);
        $datafitur = $this->home->datafiturbyid($idfitur);
        $time = time();
        $new_time = strtotime("+30 minutes", $time);
        $dataakun = $this->home->get_akunbyid($uid);
        $data                   = [
            'idtrans'                    => $idtrans,
            'idpelanggan'                => $uid,
            'alamat_asal'                => $datapelanggan->row('alamat'),
            'alamat_tujuan'              => html_escape($this->input->post('alamat_tujuan', TRUE)),
            'lat_asal'                   => $datapelanggan->row('latitude'),
            'lon_asal'                   => $datapelanggan->row('longitude'),
            'lat_tujuan'                 => html_escape($this->input->post('latitude_tujuan', TRUE)),
            'lon_tujuan'                 => html_escape($this->input->post('longitude_tujuan', TRUE)),
            'fitur'                      => html_escape($this->input->post('fitur', TRUE)),
            'harga'                      => html_escape($this->input->post('ongkir', TRUE)),
            'jarak'                      => html_escape($this->input->post('jarak', TRUE)),
            'diskon'                      => html_escape($this->input->post('diskon', TRUE)),
            'totalharga'                 => html_escape($this->input->post('totalharga', TRUE)),
            'token_cs'                 => $dataakun['token'],
            'totalharga_asli'                 => html_escape($this->input->post('totalharga', TRUE)),
            'expire'                 => date("Y-m-d H:i:s", $new_time)
        ];
        $this->home->addtransaksi($data);
        $this->session->set_flashdata('orderan', 'Orderan Berhasil Di Proses');
        //--------------- send notif -----------------------------
        $datapengguna = $this->home->alldatadriver();
        $registrationIDs = [
            '1234'
        ];
        foreach ($datapengguna as $driver) {
            $registrationIDs = [
                $driver['token']
            ];
        }
        $datanotif = [
            'title' => 'OrderIn',
            'body' => 'Ada Permintaan Pesanan , Cek Aplikasi Yukk!!',
            'type' => '1',
            'link' => base_url(),
            'idtrans' => $idtrans
        ];
        $this->home->kirimnotif($registrationIDs,$datanotif);
        //--------------------------------------------------------
        redirect('home/datadriver/'.$idtrans.'/'.$datapelanggan->row('latitude').'/'.$datapelanggan->row('longitude'));
    }
    //-------------------------- Orderan Belanja -----------------------------
    function request_orderan_belanja(){
        $this->form_validation->set_rules('alamat_asal', 'alamat_asal', 'trim|prep_for_form');
        $this->form_validation->set_rules('alamat_tujuan', 'alamat_tujuan', 'trim|prep_for_form');
        $this->form_validation->set_rules('latitude_tujuan', 'latitude_tujuan', 'trim|prep_for_form');
        $this->form_validation->set_rules('longitude_tujuan', 'longitude_tujuan', 'trim|prep_for_form');
        $this->form_validation->set_rules('fitur', 'fitur', 'trim|prep_for_form');
        $this->form_validation->set_rules('ongkir', 'ongkir', 'trim|prep_for_form');
        $this->form_validation->set_rules('jarak', 'jarak', 'trim|prep_for_form');
        $this->form_validation->set_rules('totalharga', 'totalharga', 'trim|prep_for_form');
        $this->form_validation->set_rules('diskon', 'diskon', 'trim|prep_for_form');
        $this->form_validation->set_rules('toko', 'toko', 'trim|prep_for_form');
        $this->form_validation->set_rules('catatan', 'catatan', 'trim|prep_for_form');
        $idtrans = random_int(10000, 99999);
        $uid = $this->session->userdata('uid');
        $datapelanggan = $this->home->datapelangganbyid($uid);
        $time = time();
        $new_time = strtotime("+5 minutes", $time);
        $data                   = [
            'idtrans'                    => $idtrans,
            'idpelanggan'                => $uid,
            'alamat_asal'                => $datapelanggan->row('alamat'),
            'alamat_tujuan'              => html_escape($this->input->post('alamat_tujuan', TRUE)),
            'lat_asal'                   => $datapelanggan->row('latitude'),
            'lon_asal'                   => $datapelanggan->row('longitude'),
            'lat_tujuan'                 => html_escape($this->input->post('latitude_tujuan', TRUE)),
            'lon_tujuan'                 => html_escape($this->input->post('longitude_tujuan', TRUE)),
            'fitur'                      => html_escape($this->input->post('fitur', TRUE)),
            'harga'                      => html_escape($this->input->post('ongkir', TRUE)),
            'parkir'                      => html_escape($this->input->post('parkir', TRUE)),
            'jarak'                      => html_escape($this->input->post('jarak', TRUE)),
            'diskon'                      => html_escape($this->input->post('diskon', TRUE)),
            'totalharga'                 => html_escape($this->input->post('totalharga', TRUE)),
            'totalharga_asli'                 => html_escape($this->input->post('totalharga', TRUE)),
            'expire'                    => date("Y-m-d H:i:s", $new_time)
        ];
        $datatoko                   = [
            'idtrans'                    => $idtrans,
            'toko'                => html_escape($this->input->post('toko', TRUE)),
            'catatan'                => $this->input->post('catatan', TRUE),
        ];
        $orderbelanja = $this->home->addtransaksibelanja($datatoko);
        $this->home->addtransaksi($data);
        $this->session->set_flashdata('orderan', 'Orderan Berhasil Di Proses');
        redirect('home/datadriver/'.$idtrans.'/'.$datapelanggan->row('latitude').'/'.$datapelanggan->row('longitude'));
    }
    public function updatelokasi_post(){
        $this->form_validation->set_rules('alamat', 'alamat', 'trim|prep_for_form');
        $this->form_validation->set_rules('latitude', 'latitude', 'trim|prep_for_form');
        $this->form_validation->set_rules('longitude', 'longitude', 'trim|prep_for_form');
        $uid = $this->session->userdata('uid');
        $data                   = [
            'uid'                 => $uid,
            'alamat'                 => html_escape($this->input->post('alamat', TRUE)),
            'latitude'                 => html_escape($this->input->post('latitude', TRUE)),
            'longitude'                 => html_escape($this->input->post('longitude', TRUE))
        ];
        $this->home->editalamat($data);
        $this->session->set_flashdata('orderan', 'Orderan Berhasil Di Proses');
        redirect('home/sukses_order');
    }
    function detailorder($id)
	{
        if($this->session->userdata('type') == '1'){
            $check_exist = $this->home->check_exist_transaksibyid($id);
            if($check_exist){
                $this->session->set_flashdata('orderan', 'Orderan Tidak Tersedia');
                redirect('home');
            }else{
                $check_exist_pengajuan = $this->home->check_exist_pengajuan($id);
                if($check_exist_pengajuan){
                    $uid = $this->session->userdata('uid');
                    $data['page'] = $this->home->landingpage();
                    $data['akun'] = $this->home->get_akunbyid($uid);
                    $data['nego'] = 'Ya';
                    $data['transaksi'] = $this->home->transaksidriverbyid($id);
                    $data['belanja'] = $this->home->databelanja($id);
                    $this->load->view('includes/header',$data);
                    $this->load->view('pelanggan/progress', $data);
                    $this->load->view('includes/footer',$data);
                }else{
                    $uid = $this->session->userdata('uid');
                    $data['page'] = $this->home->landingpage();
                    $data['akun'] = $this->home->get_akunbyid($uid);
                    $data['nego'] = 'Tidak';
                    $data['transaksi'] = $this->home->transaksidriverbyid($id);
                    $data['belanja'] = $this->home->databelanja($id);
                    $this->load->view('includes/header',$data);
                    $this->load->view('pelanggan/progress', $data);
                    $this->load->view('includes/footer',$data);
                }
                
            }
        }else{
            redirect('home');
        }
        
	}
    public function penjemputan($id){
        $data                   = [
            'id'                => $id,
            'status'            => '2',
        ];
        $this->home->setstatus($data);
        //--------------- send notif -----------------------------
        $datatrans = $this->home->datatransbyid($id);
        $tokendevice = $datatrans->row('token_cs');
        $registrationIDs = [
            $tokendevice
        ];
      
        $datanotif = [
            'title' => 'OrderIn',
            'body' => 'Driver Menuju Ke Titik Penjemputan!!',
            'type' => '3',
            'link' => base_url().'progressorder/'.$id,
            'idtrans' => $id
        ];
        $this->home->kirimnotif($registrationIDs,$datanotif);
        //--------------------------------------------------------
        redirect('home/detailorder/'.$id);
    }
    public function pengantaran($id){
        $data                   = [
            'id'                => $id,
            'status'            => '3',
        ];
        $this->home->setstatus($data);
        //--------------- send notif -----------------------------
        $datatrans = $this->home->datatransbyid($id);
        $tokendevice = $datatrans->row('token_cs');
        $registrationIDs = [
            $tokendevice
        ];
       
        $datanotif = [
            'title' => 'OrderIn',
            'body' => 'Driver Menuju Ke Titik Pengantaran!!',
            'type' => '4',
            'link' => base_url().'progressorder/'.$id,
            'idtrans' => $id
        ];
        $this->home->kirimnotif($registrationIDs,$datanotif);
        //--------------------------------------------------------
        redirect('home/detailorder/'.$id);
    }
    public function orderselesai($id){
        $datatrans = $this->home->datatransbyid($id);
        $datareset                   = [
            'idtrans'                => $id,
            'iddriver'            => $datatrans->row('iddriver'),
        ];
        $data                   = [
            'id'                => $id,
            'status'            => '4',
        ];
        //--------------- send notif -----------------------------
        $datatrans = $this->home->datatransbyid($id);
        $tokendevice = $datatrans->row('token_cs');
        $registrationIDs = [
            $tokendevice
        ];
 
        $datanotif = [
            'title' => 'OrderIn',
            'body' => 'Orderan Telah Di Selesaikan!!',
            'type' => '5',
            'link' => base_url(),
            'idtrans' => $id
        ];
        $this->home->kirimnotif($registrationIDs,$datanotif);
        //--------------------------------------------------------
        $this->home->resetstatus($datareset);
        $this->home->setstatus($data);
        $this->session->set_flashdata('orderan', 'Orderan Berhasil Di Selesaikan');
        redirect('home/index/');
    }
    public function request_pengajuan($id){
        $idtrx = html_escape($this->input->post('idtrans', TRUE));
        $idpel = html_escape($this->input->post('idpelanggan', TRUE));
        $uid = $this->session->userdata('uid');
        $dataakun = $this->home->get_akunbyid($idpel);
        $check_exist_pengajuan = $this->home->check_exist_pengajuan($idtrx);
        if($check_exist_pengajuan){
            $this->session->set_flashdata('orderan', 'Sudah Melakukan Pengajuan');
            redirect('home/index/');
        }else{
            $data                   = [
                'idtrans'           => $idtrx,
                'iddriver'           => $uid,
                'pengajuan'            => html_escape($this->input->post('harga', TRUE)),
            ];
            $this->home->insertpengajuan($data);
            $namadriver = $this->session->userdata('fullnama');
            //--------------- send notif -----------------------------
            $datatrans = $this->home->datatransbyid($id);
            $tokendevice = $datatrans->row('token_cs');
            $registrationIDs = [
                $tokendevice
            ];
           
            $actionNoti = base_url()."home/orderan";

            $datanotif = [
                'title' => 'OrderIn',
                'body' => $namadriver.' Mengajukan Permintaan Harga\nCek Pesanan Kamu Yuk!!',
                'type' => '6',
                'link' => base_url().'home/datadriver/'.$id.'/'.$datatrans->row('lat_asal').'/'.$datatrans->row('lon_asal'),
                'idtrans' => $id
            ];
            $this->home->kirimnotif($registrationIDs,$datanotif);
            //--------------------------------------------------------
            
            $this->session->set_flashdata('orderan', 'Pengajuan Berhasil Di Ajukan');
            redirect('home/index/');
        }
        
    }
    public function hubungidriver($id,$iddriver){
        $datapelanggan = $this->home->datapelangganbyid($iddriver);
        $txt1 = "-------------------- Pesan Dari Customers -------------------"."\n";
        $txt3 = "Customer : ".$datapelanggan->row('fullnama')."\n";
        $txt4 = "Buka Web Gojasa Untuk Proses Orderan"."\n";
        $txt5 = base_url()."\n";
        $txt6 = "------------------------------------------------"."\n";
        $txt4 = "Hallo Kak";
        $pesanwa = utf8_encode($txt1.$txt2.$txt3.$txt4.$txt5.$txt6.$txt7);
        $curl = curl_init();
        curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://apiwa.mwdigi.com/send-message',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => array('message' => $pesanwa,'number' => $datapelanggan->row('kontak')),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        redirect('home/progressorder/'.$id);
    }
    //--------------- post chat ----------------------------
    function kirimchat($idtrans){
        $this->form_validation->set_rules('pesan', 'pesan', 'trim|prep_for_form');
        $uid = $this->session->userdata('uid');
        $level = $this->session->userdata('type');
        $leveluser = null;
        $registrationIDs = [
            '1234'
        ];
        if($level == '1'){
            $leveluser = 'driver';
            $datapengguna = $this->home->alldatadriversbytrx($idtrans);
            foreach ($datapengguna as $customer) {
                $registrationIDs = [
                    $customer['token']
                ];
            }
        }else{
            $leveluser = 'customer';
            $datapengguna = $this->home->alldatacustomerbytrx($idtrans);
            foreach ($datapengguna as $customer) {
                $registrationIDs = [
                    $customer['token']
                ];
            }
        }
        $data                   = [
            'idtrans'            => $idtrans,
            'uid'                => $uid,
            'pesan'              => html_escape($this->input->post('pesan', TRUE)),
            'level'              => $leveluser
        ];
        
        $datanotif = [
            'title' => $leveluser,
            'body' => html_escape($this->input->post('pesan', TRUE)),
            'type' => '100',
            'link' => base_url().'/home/chat/'.$idtrans,
            'idtrans' => $idtrans
        ];
        $this->home->kirimnotif($registrationIDs,$datanotif);
        $this->home->postchat($data);
        redirect('home/chat/'.$idtrans);
    }

}
