<?php
defined('BASEPATH') or exit('No direct script access allowed');
require_once('vendor/autoload.php');
class Login extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Home_model', 'home');
        $this->load->model('Login_model', 'login');
		$this->load->library('form_validation');
    }
	function index()
	{
        if ($this->session->userdata('username') != NULL && $this->session->userdata('password') != NULL) {
			redirect(base_url("home"));
		}
        $data['page'] = $this->home->landingpage();
		$this->load->view('login/index',$data);
	}
	public function google()
	{
		  $google_client = new Google_Client();
		  $google_client->setClientId('754869015939-gmakaabcie8007qva7blnao4fqlmbpv5.apps.googleusercontent.com'); //masukkan ClientID anda 
		  $google_client->setClientSecret('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'); //masukkan Client Secret Key anda
		  $google_client->setRedirectUri(base_url("login/google")); //Masukkan Redirect Uri anda
		  $google_client->addScope('email');
		  $google_client->addScope('profile');

		  if(isset($_GET["code"]))
		  {
		   $token = $google_client->fetchAccessTokenWithAuthCode($_GET["code"]);
		   if(!isset($token["error"]))
		   {
		    $google_client->setAccessToken($token['access_token']);
		    $this->session->set_userdata('access_token', $token['access_token']);
		    $google_service = new Google_Service_Oauth2($google_client);
		    $data = $google_service->userinfo->get();
		    $current_datetime = date('Y-m-d H:i:s');
		    $user_data = array(
		      'first_name' => $data['given_name'],
		      'last_name'  => $data['family_name'],
		      'email_address' => $data['email'],
		      'profile_picture'=> $data['picture'],
		      'updated_at' => $current_datetime
		     );
		    $this->session->set_userdata('user_data', $data);
		   }									
		  }
		  $login_button = '';
		  if(!$this->session->userdata('access_token'))
		  {
		  	
		   $login_button = '<a href="'.$google_client->createAuthUrl().'"><img src="https://1.bp.blogspot.com/-gvncBD5VwqU/YEnYxS5Ht7I/AAAAAAAAAXU/fsSRah1rL9s3MXM1xv8V471cVOsQRJQlQCLcBGAsYHQ/s320/google_logo.png" /></a>';
		   $data['login_button'] = $login_button;
		   $this->load->view('google_login', $data);
		  }
		  else
		  {
		  	// uncomentar kode dibawah untuk melihat data session email
		  	// echo json_encode($this->session->userdata('access_token')); 
		  	// echo json_encode($this->session->userdata('user_data'));
		   echo "Login success";
		  }
	}
	function daftar(){
		$this->form_validation->set_rules('username', 'username', 'trim|prep_for_form');
        $this->form_validation->set_rules('fullnama', 'fullnama', 'trim|prep_for_form');
        $this->form_validation->set_rules('kontak', 'kontak', 'trim|prep_for_form');
        $this->form_validation->set_rules('email', 'email', 'trim|prep_for_form');
		$this->form_validation->set_rules('accountType', 'accountType', 'trim|prep_for_form');
        $idakun = random_int(10000, 99999);
        if ($this->form_validation->run() == TRUE) {  
            $data                   = [
                'uid'                            => $idakun,
                'username'                          => html_escape($this->input->post('username', TRUE)),
                'fullnama'                         => html_escape($this->input->post('fullnama', TRUE)),
                'email'                    => html_escape($this->input->post('email', TRUE)),
                'kontak'                    => html_escape($this->input->post('kontak', TRUE)),
				'type'                    => html_escape($this->input->post('accountType', TRUE)),
                'foto'                          => 'noimage.jpg',
                'password'                        => sha1(html_escape($this->input->post('password', TRUE)))
            ];
            $this->login->daftar($data);
            $this->session->set_flashdata('daftar', 'Pendaftaran Berhasil');
            redirect('login');
        } else {
            $data['page'] = $this->home->landingpage();
            $this->load->view('login/daftar', $data);
        }
	}
    function aksi_login()
	{
		$nama = html_escape($this->input->post('username', TRUE));
		$acak = html_escape($this->input->post('password', TRUE));
		$pass = sha1($acak);
		$user = $this->db->get_where('pengguna', ['username' => $nama])->row_array();
		$passDB = $user['password'];
		if ($user) {
			if ($passDB != $pass) {
				$this->session->set_flashdata('error', 'Password Salah!');
				redirect('login');
			} else {
				$data = [
					'uid' => $user['uid'],
					'username' => $user['username'],
					'fullnama' => $user['fullnama'],
					'email' => $user['email'],
					'kontak' => $user['kontak'],
					'alamat' => $user['alamat'],
					'password' => $user['password'],
					'type' => $user['type'],
					'level' => $user['level'],
					'foto' => $user['foto']
				];
				$this->session->set_userdata($data);
				redirect('home');
			}
		} else {
			$this->session->set_flashdata('error', 'Username / Password Salah');
			redirect('login');
		}
	}
	function logout()
	{
		$this->session->sess_destroy();
		redirect('login');
	}
}
