<?php
//'tes' => number_format(200 / 100, 0, ",", "."),
defined('BASEPATH') or exit('No direct script access allowed');
require APPPATH . '/libraries/REST_Controller.php';
require_once('vendor/autoload.php');
class Orderan extends REST_Controller
{

    public function __construct()
    {
        parent::__construct();
        
        $this->load->helper("url");
        $this->load->database();
        $this->load->model('Home_model', 'home');
        date_default_timezone_set('Asia/Jakarta');
    }

    function index_get()
    {
        $this->response("Api for Gojasa!", 200);
    }
    function dataorder_get($id){
        $near = $this->home->get_dataorder($id);
        $message = array(
            'data' => $near->result()
        );
        $this->response($message, 200);
    }
    function datafitur_get($id){
        $near = $this->home->get_datafiturbyid($id);
        $message = array(
            'data' => $near->result()
        );
        $this->response($message, 200);
    }
    function datachat_get($id){
        $near = $this->home->get_datahchat($id);
        $message = array(
            'data' => $near->result()
        );
        $this->response($message, 200);
    }
    function datadriver_get($lat,$lng){
        $near = $this->home->get_driver_ride_new($lat,$lng);
        $message = array(
            'data' => $near->result()
        );
        $this->response($message, 200);
    }
    function dataprogress_get(){
        $near = $this->home->get_dataprogress();
        $message = array(
            'data' => $near->result()
        );
        $this->response($message, 200);
    }
    function updatetoken_post(){
        $uid = $this->session->userdata('uid');
        $datatoken                   = [
            'token'          => $_POST["devicetoken"],
            'uid'          => $uid
        ];
        $this->home->updatetoken($datatoken);
        $message = array(
            'message' => 'Sukses'
        );
        $this->response($message, 200);
    }
}