<!-- Header Area-->
<div class="header-area" id="headerArea">
      <div class="container h-100 d-flex align-items-center justify-content-between rtl-flex-d-row-r">
        <!-- Back Button-->
        <div class="back-button me-2"><a href="cart.html"><i class="fa-solid fa-arrow-left-long"></i></a></div>
        <!-- Page Title-->
        <div class="page-heading">
          <h6 class="mb-0"><?= $fitur['fitur']; ?></h6>
        </div>
        <div><span></span><span></span><span></span></div>
      </div>
    </div>
    
    <div class="page-content-wrapper">
      <div class="container">
      <div class="pt-3">
            <!-- Hero Slides-->
            <div class="hero-slides owl-carousel">
              <!-- Single Hero Slide-->
              <?php $i = 1;
              foreach ($banner as $bnr) { ?>
              <div class="single-hero-slide" style="background-image: url('<?= base_url(); ?>images/promo/<?= $bnr['image']; ?>')"></div>
              <?php $i++;
              } ?>
            </div>
          </div>
        <!-- Checkout Wrapper-->
      
        <div class="checkout-wrapper-area py-3">
          <?= form_open_multipart('home/request_orderan_belanja'); ?>
          <!-- Billing Address-->
          <div class="billing-information-card mb-3">
            <div class="card billing-information-title-card bg-danger">
              <div class="card-body">
                <h6 class="text-center mb-0 text-white">Detail Alamat</h6>
              </div>
            </div>
            <div class="card user-data-card">
              <div class="card-body">
                <!-- request order -->
                <input class="form-control" id="idfitur" name="fitur" type="text" value="<?= $fitur['id']; ?>" hidden>
                <input type="text" id="latitude_asal" name="latitude_asal" value="<?= $akun['latitude']; ?>" class="form-control" hidden>
                <input type="text" id="longitude_asal" name="longitude_asal" value="<?= $akun['longitude']; ?>" class="form-control" hidden>
                
                <input type="text" id="set_ongkir" name="ongkir"  class="form-control" hidden>
                <input type="text" id="set_jarak" name="jarak"  class="form-control" hidden>
                <input type="text" id="set_diskon" name="diskon"  class="form-control" hidden>
                <input type="text" id="set_total" name="totalharga"  class="form-control" hidden>
                <input type="text" id="set_parkir" name="parkir"  class="form-control" hidden>
                <!-- ----------------------------- Jemputan -------------------------- -->
                <div class="mb-3" id="id_asal">
                  <div class="title mb-2"><i class="fa-solid fa-location-dot"></i><span>Alamat Penjemputan</span></div>
                    <input type="text" class="form-control" name="alamat_asal" id="alamat" value="<?= $akun['alamat']; ?>" disabled/>
                </div>
                <!-- ----------------------------- Tujuan -------------------------- -->
                <div class="mb-3" id="id_tujuan">
                  <div class="title mb-2"><i class="fa-solid fa-location-dot"></i><span>Alamat Tujuan</span></div>
                    <input type="text" class="form-control" name="alamat_tujuan" id="tujuan" placeholder="Alamat Lengkap Tujuan" hidden/>
                    <input type="text" class="form-control" id="alamat_tujuan" placeholder="Alamat Lengkap Tujuan" disabled/>
                </div>
                
                <div class="mb-3" id="part_cari">
                  <div class="title mb-2"><i class="fa-solid fa-location-dot"></i><span>Tentukan Lokasi Pembelian</span></div>
                  <script type="text/javascript">
                    function clearThis(target){
                        target.value= "";
                    }
                    </script>
                  <input type="text" class="form-control" id="us4-address" onfocus="clearThis(this)"/>
                </div>
                <div class="row mb-3" id="mappick">
                    <div class="col-sm-12">
                        <div id="us4" style="width: 100%; height: 200px;"></div>
                    </div>
                </div>

                <div class="row mb-3" hidden>
                    <div class="form-group row">
                    <div class="col-sm-6">
                    <label>Latitude</label>
                    <input type="text" name="latitude_tujuan" id="us4-lat" class="form-control">
                    </div>
                    <div class="col-sm-6">
                    <label>Longitude</label>
                    <input type="text" name="longitude_tujuan" id="us4-lon" class="form-control">
                    </div>
                    </div>
                </div>
                <!-- ----------------------------- Nama Toko -------------------------- -->
                <div class="mb-3" id="toko">
                  <div class="title mb-2"><i class="fa-solid fa-store"></i><span>Nama Toko</span></div>
                    <input type="text" class="form-control" name="toko" placeholder="Toko Surya"/>
                </div>
                <!-- ----------------------------- Catatan Belanja -------------------------- -->
                <div class="mb-3" id="catatan">
                  <div class="title mb-2"><i class="fa-solid fa-store"></i><span>Catatan Belanja</span></div>
                  <textarea class="form-control" id="catatan" name="catatan" placeholder="Nama Item 1Pcs &NewLine;Nama Item 1Pak"></textarea>
                </div>
              </div>
            </div>
          </div>
          <!-- Shipping Method Choose-->
          <div class="shipping-method-choose mb-3" id="payment">
            <div class="card shipping-method-choose-title-card bg-success">
              <div class="card-body">
                <h6 class="text-center mb-0 text-white">Pembayaran</h6>
              </div>
            </div>
            <div class="card shipping-method-choose-card">
              <div class="card-body">
                <div class="single-profile-data d-flex align-items-center justify-content-between">
                        <div class="title d-flex align-items-center"><i class="fa-solid fa-money-bill"></i><span>Ongkir</span></div>
                        <div class="data-content" id="req_ongkir"></div>
                </div>
                <div class="single-profile-data d-flex align-items-center justify-content-between">
                    <div class="title d-flex align-items-center"><i class="fa-solid fa-location-dot"></i><span>Jarak (km)</span></div>
                    <div class="data-content" id="req_jarak"></div>
                </div>
                <div class="single-profile-data d-flex align-items-center justify-content-between">
                        <div class="title d-flex align-items-center"><i class="fa-solid fa-tag"></i><span>Potongan</span></div>
                        <div class="data-content" id="req_diskon"></div>
                </div>
                
                <div class="shipping-method-choose">
                  <ul class="ps-0">
                    <li>
                      <input id="tunai" type="radio" name="selector" checked>
                      <label for="tunai">COD<span>Bayar Ditempat</span></label>
                      <div class="check"></div>
                    </li>
                    <li>
                      <input id="ewallet" type="radio" name="selector" disabled>
                      <label for="ewallet">E-Wallet<span>Lebih MurahBayar Pake E-Wallet</span></label>
                      <div class="check"></div>
                    </li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
          <!-- Cart Amount Area-->
          <div id="cardpayment" class="card cart-amount-area">
            <div class="card-body d-flex align-items-center justify-content-between">
                <p id="nominal" hidden></p>
                <h5 class="total-price mb-0"><span id="req_totalbiaya"></span></h5><button type="submit" class="btn btn-success w-50">Order Sekarang</button>
            </div>
          </div>
          <?= form_close(); ?>
        </div>
      </div>
    </div>
<!-- partial -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/1/jquery.min.js"></script>
<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?sensor=true&libraries=places">
</script>
<script type="text/javascript"  src='https://maps.google.com/maps/api/js?key=AIzaSyA_6KZyjBsapw01AHTcehSiCyRcE8pFtjM&sensor=false&libraries=places'></script>
<script src="<?= base_url(); ?>assets/js/locationpicker.jquery.js"></script>

<script>
    document.getElementById("payment").hidden=true;
    document.getElementById("cardpayment").hidden=true;
    document.getElementById("id_asal").hidden=true;
    document.getElementById("id_tujuan").hidden=true;
    document.getElementById("toko").hidden=true;
    document.getElementById("catatan").hidden=true;
    const latasal = document.getElementById("latitude_asal");
    const lonasal = document.getElementById("longitude_asal");
    const lattujuan = document.getElementById("us4-lat");
    const lontujuan = document.getElementById("us4-lon");
    let minharga = 0;
    let harga = 0
    let jarak = 1;
    let minjarak = 1;
    let ongkir = 0;
    let diskon = 0;
    let totalharga = 0;
    let parkir = 0;
    let nextharga = 0;
    //-------------------- Load Fitur -------------------------------------
    loadfitur();
    function loadfitur(){
      var idfitur = document.getElementById("idfitur").value;
        $.ajax({
          url: "<?php echo base_url(); ?>api/orderan/datafitur/"+idfitur,
          type: "GET",
          success: function(data) {
              var data_parse = data.data;
              for (var i = 0; i < data_parse.length; i++) {
                  var fitur = data_parse[i].fitur;
                  minharga = data_parse[i].minharga;
                  minjarak = data_parse[i].minjarak;
                  harga =  data_parse[i].harga;
                  diskon =  data_parse[i].diskon;
                  parkir =  data_parse[i].parkir;
                  nextharga = parseFloat(minharga) + parseFloat(harga) + parseFloat(parkir);
                  document.getElementById("set_diskon").value = diskon;
                  document.getElementById("set_parkir").value = parkir;
              }
          }
        });
    }
    //--------------------------------------------------------------------
    
    function loadalamat(currentLocation){
      var myLatlng = new google.maps.LatLng( currentLocation.latitude, currentLocation.longitude);
          var geocoder = geocoder = new google.maps.Geocoder();
          geocoder.geocode({ 'latLng': myLatlng }, function (results, status) {
            if (status == google.maps.GeocoderStatus.OK) {
              if (results[1]) {
                document.getElementById("id_asal").hidden=false;
                document.getElementById("id_tujuan").hidden=false;
                document.getElementById('alamat_tujuan').value = results[1].formatted_address;
                document.getElementById('tujuan').value = results[1].formatted_address;
                document.getElementById("part_cari").hidden=true;
                document.getElementById("mappick").hidden=true;
                document.getElementById("payment").hidden=false;
                document.getElementById("toko").hidden=false;
                document.getElementById("catatan").hidden=false;
              }
            }
      });
    }
    
    $('#us4').locationpicker({
        location: {
            latitude: -6.4575854,
            longitude: 108.2813575
        },
        radius: 0,
        inputBinding: {
            latitudeInput: $('#us4-lat'),
            longitudeInput: $('#us4-lon'),
            radiusInput: $('#us4-radius'),
            locationNameInput: $('#us4-address')
        },
        enableAutocomplete: true,
        onchanged: function(currentLocation, radius, isMarkerDropped) {
            loadalamat(currentLocation);
            jarak = calcCrow(latasal.value,lonasal.value,lattujuan.value,lontujuan.value).toFixed(0);
            if(jarak < minjarak){
              ongkir = parseFloat(minharga + parkir);
            }else{
              ongkir = parseFloat(nextharga * jarak);
            }
     
            totalharga = parseFloat(ongkir) - parseFloat(diskon);
            document.getElementById("req_jarak").innerHTML = jarak;
            //request order
            document.getElementById("set_ongkir").value = ongkir.toString();
            document.getElementById("set_jarak").value = jarak.toString();
            document.getElementById("set_total").value = totalharga.toString();
            //--------------------------------------------------------
            document.getElementById("req_diskon").innerHTML = formatRupiah(diskon.toString(), 'Rp');
            document.getElementById("req_ongkir").innerHTML = formatRupiah(ongkir.toString(), 'Rp');
            document.getElementById("req_totalbiaya").innerHTML = formatRupiah(totalharga.toString(), 'Rp');
            document.getElementById("cardpayment").hidden=false;
        }
    });

    //This function takes in latitude and longitude of two location and returns the distance between them as the crow flies (in km)
    function calcCrow(lat1, lon1, lat2, lon2) 
    {
      var R = 6371; // km
      var dLat = toRad(lat2-lat1);
      var dLon = toRad(lon2-lon1);
      var lat1 = toRad(lat1);
      var lat2 = toRad(lat2);

      var a = Math.sin(dLat/2) * Math.sin(dLat/2) +
        Math.sin(dLon/2) * Math.sin(dLon/2) * Math.cos(lat1) * Math.cos(lat2); 
      var c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1-a)); 
      var d = R * c;
      return d;
    }

    // Converts numeric degrees to radians
    function toRad(Value) 
    {
        return Value * Math.PI / 180;
    }
    /* Fungsi formatRupiah */
	function formatRupiah(angka, prefix){
			var number_string = angka.replace(/[^,\d]/g, '').toString(),
			split   		= number_string.split(','),
			sisa     		= split[0].length % 3,
			rupiah     		= split[0].substr(0, sisa),
			ribuan     		= split[0].substr(sisa).match(/\d{3}/gi);
 
			// tambahkan titik jika yang di input sudah menjadi angka ribuan
			if(ribuan){
				separator = sisa ? '.' : '';
				rupiah += separator + ribuan.join('.');
			}
 
			rupiah = split[1] != undefined ? rupiah + ',' + split[1] : rupiah;
			return prefix == undefined ? rupiah : (rupiah ? 'Rp ' + rupiah : '');
	}
</script>