<!-- Preloader-->
<div class="preloader" id="preloader">
      <div class="spinner-grow text-secondary" role="status">
        <div class="sr-only"></div>
      </div>
    </div>
    <!-- Header Area-->
    <div class="header-area" id="headerArea">
      <div class="container h-100 d-flex align-items-center justify-content-between rtl-flex-d-row-r">
        <!-- Back Button-->
        <div class="back-button me-2"><a href="cart.html"><i class="fa-solid fa-arrow-left-long"></i></a></div>
        <!-- Page Title-->
        <div class="page-heading">
          <h6 class="mb-0">Detail Transaksi</h6>
        </div>
        <div><span></span><span></span><span></span></div>
      </div>
    </div>
    
    <div class="page-content-wrapper">
      <div class="container">
        <!-- Checkout Wrapper-->
        <div class="checkout-wrapper-area py-3">
          <!-- Billing Address-->
          <div class="billing-information-card mb-3">
            <div class="card billing-information-title-card bg-danger">
              <div class="card-body">
                <h6 class="text-center mb-0 text-white">Informasi</h6>
                <input type="text" id="id_transaksi" value="<?= $transaksi['idtrans']; ?>" hidden/>
              </div>
            </div>
            <div class="card user-data-card">
              <div class="card-body">                                   
                <div class="single-profile-data d-flex align-items-center justify-content-between">
                  <div class="title d-flex align-items-center"><i class="fa-solid fa-user"></i><span>Nama Pelanggan</span></div>
                  <div class="data-content"><?= $transaksi['fullnama']; ?></div>
                </div>
                <div class="single-profile-data d-flex align-items-center justify-content-between">
                  <div class="title d-flex align-items-center"><i class="fa-solid fa-user"></i><span>Kontak</span></div>
                  <div class="data-content"><a class="btn btn-success" href="https://wa.me/<?= $transaksi['kontak']; ?>?text=Halo,%20Kak%20Saya%20Driver%20Dari%20Gojasa">Hubungi</a></div>
                </div>
                <div class="single-profile-data d-flex align-items-center justify-content-between">
                  <div class="title d-flex align-items-center"><i class="fa-solid fa-bars"></i><span>Layanan</span></div>
                  <div class="data-content"><?= $transaksi['service']; ?></div>
                </div>
                <div class="single-profile-data d-flex align-items-center justify-content-between">
                  <div class="title d-flex align-items-center"><i class="fa-solid fa-location-crosshairs"></i><span>Alamat Asal</span></div>
                  <div class="data-content"><?= $transaksi['alamat_asal']; ?></div>
                </div>
                <div class="single-profile-data d-flex align-items-center justify-content-between">
                  <div class="title d-flex align-items-center"><i class="fa-solid fa-location-dot"></i><span>Alamat Tujuan</span></div>
                  <div class="data-content"><?= $transaksi['alamat_tujuan']; ?></div>
                </div>
                <?php if ($transaksi['layanan'] == 'belanja'): ?>
                    <div class="single-profile-data d-flex align-items-center justify-content-between">
                        <div class="title d-flex align-items-center"><i class="fa-solid fa-store"></i><span>Nama Tempat</span></div>
                    <div class="data-content"><?= $belanja['toko']; ?></div>
                    </div>
                    <div class="single-profile-data d-flex align-items-center justify-content-between">
                        <div class="title d-flex align-items-center"><i class="fa-solid fa-list"></i><span>Catatan</span></div>
                    </div>
                    <div class="data-content"><textarea class="form-control" disabled><?= $belanja['catatan']; ?></textarea></div>
                    <br>  
                <?php endif ?>
                
                <?php if ($transaksi['status'] == '1'): ?>
                    <?php if ($transaksi['layanan'] == 'belanja'): ?>
                        <a class="btn btn-danger w-100" href="http://maps.google.com/maps?z=12&t=m&q=<?= $transaksi['lat_asal']; ?>,<?= $transaksi['lon_asal']; ?>">Map Titik Toko</a>
                    <?php else: ?>
                        <a class="btn btn-danger w-100" href="http://maps.google.com/maps?z=12&t=m&q=<?= $transaksi['lat_asal']; ?>,<?= $transaksi['lon_asal']; ?>">Map Titik Asal</a>
                    <?php endif ?>
                <?php endif ?>
                <?php if ($transaksi['status'] == '2'): ?>
                    <?php if ($transaksi['layanan'] == 'belanja'): ?>
                        <a class="btn btn-danger w-100" href="http://maps.google.com/maps?z=12&t=m&q=<?= $transaksi['lat_asal']; ?>,<?= $transaksi['lon_asal']; ?>">Map Titik Toko</a>
                    <?php else: ?>
                        <a class="btn btn-danger w-100" href="http://maps.google.com/maps?z=12&t=m&q=<?= $transaksi['lat_asal']; ?>,<?= $transaksi['lon_asal']; ?>">Map Titik Asal</a>
                    <?php endif ?>
                <?php endif ?>
                <?php if ($transaksi['status'] == '3'): ?>
                    <a class="btn btn-danger w-100" href="http://maps.google.com/maps?z=12&t=m&q=<?= $transaksi['lat_tujuan']; ?>,<?= $transaksi['lon_tujuan']; ?>">Map Titik Tujuan</a>
                <?php endif ?>
              </div>
            </div>
          </div>
          <!-- Shipping Method Choose-->
          <div class="shipping-method-choose mb-3">
            <div class="card shipping-method-choose-title-card bg-success">
              <div class="card-body">
                <h6 class="text-center mb-0 text-white">Pembayaran</h6>
              </div>
            </div>
            <div class="card shipping-method-choose-card">
              <div class="card-body">
                <div class="single-profile-data d-flex align-items-center justify-content-between">
                  <div class="title d-flex align-items-center"><i class="fa-solid fa-money-bill"></i><span>Ongkir</span></div>
                  <div class="data-content">Rp<?= rupiah($transaksi['harga']); ?></div>
                </div>
                <div class="single-profile-data d-flex align-items-center justify-content-between">
                  <div class="title d-flex align-items-center"><i class="fa-solid fa-location-dot"></i><span>Jarak</span></div>
                  <div class="data-content"><?= $transaksi['jarak']; ?> Km</div>
                </div>
                <div class="single-profile-data d-flex align-items-center justify-content-between">
                  <div class="title d-flex align-items-center"><i class="fa-solid fa-money-bill"></i><span>Potongan</span></div>
                  <div class="data-content">Rp<?= rupiah($transaksi['diskon']); ?></div>
                </div>
                <div class="single-profile-data d-flex align-items-center justify-content-between">
                  <div class="title d-flex align-items-center"><i class="fa-solid fa-wallet"></i><span>Pembayaran</span></div>
                  <div class="data-content">Bayar Ditempat</div>
                </div>
              </div>
            </div>
          </div>
          <!-- Cart Amount Area-->
          <div class="card cart-amount-area">
            <div class="card-body d-flex align-items-center justify-content-between">
              <h5 class="total-price mb-0">Rp<span class="counter"><?= rupiah($transaksi['totalharga']); ?></span></h5>
              <div class="btn-group">
                <?php if ($transaksi['status'] == '1') { ?>
                    <?php if ($transaksi['layanan'] == 'belanja'): ?>
                        <a class="btn btn-warning" href="<?= base_url(); ?>home/penjemputan/<?= $transaksi['idtrans']; ?>">Menuju Ke Toko</a>
                    <?php else: ?>
                        <a class="btn btn-warning" href="<?= base_url(); ?>home/penjemputan/<?= $transaksi['idtrans']; ?>">Jemput</a>
                    <?php endif ?>
                    
                <?php } ?>
                <?php if ($transaksi['status'] == '2') { ?>
                    <a class="btn btn-primary" href="<?= base_url(); ?>home/pengantaran/<?= $transaksi['idtrans']; ?>">Antar</a>
                <?php } ?>
                <?php if ($transaksi['status'] == '3') { ?>
                    <a class="btn btn-success" href="<?= base_url(); ?>home/orderselesai/<?= $transaksi['idtrans']; ?>">Selesai</a>
                <?php } ?>
                <a id='tombol' class="btn btn-danger" href="<?= base_url(); ?>home/cancelorderindriver/<?= $transaksi['idtrans']; ?>/<?= $transaksi['iddriver']; ?>">Batalkan</a>
                </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
    <script>
        
        loadContent();
        function loadContent(){
            var idtransaksi = document.getElementById("id_transaksi").value;
            $.ajax({
            url: "<?php echo base_url(); ?>api/orderan/dataorder/"+idtransaksi,
            type: "GET",
            success: function(data) {
                var data_parse = data.data;
                for (var i = 0; i < data_parse.length; i++) {
                    var idtrans = data_parse[i].id;
                    var waktu = data_parse[i].waktu;
                    var statusorder = data_parse[i].status;
                }
               
                if(statusorder == '5'){
                  alert('Pesanan Telah Dibatalkan');
                    window.location = '<?php echo base_url();?>';  
                }
              setTimeout(function(){
                loadContent();
              }, 5000);
            }
            });
        }
    </script>